<?php namespace App\Controllers;

class Product extends BaseController {

	private $path = 'templates';

	public function index() {
		$language = $this->session->language;
		$page_title = 'Products';
		$page_active = 'product';

		$products = array(
			array('name'=>'Grooving Inserts', 'picture'=>'assets/images/products/grooving_inserts.png', 'link_docs'=>'assets/files/products/grooving_inserts.pdf'),
			array('name'=>'PCBN PCD Inserts', 'picture'=>'assets/images/products/pcbn_pcd_inserts.png', 'link_docs'=>'assets/files/products/pcbn_pcd_inserts.pdf'),
			array('name'=>'Carbide Inserts', 'picture'=>'assets/images/products/carbide_inserts.png', 'link_docs'=>'assets/files/products/carbide_inserts.pdf'),
			array('name'=>'U Drills and Spade Drills', 'picture'=>'assets/images/products/u_drills_and_spade_drills.png', 'link_docs'=>'assets/files/products/u_drills_and_spade_drills.pdf'),
			array('name'=>'Carbide end Mill', 'picture'=>'assets/images/products/carbide_end_mill.png', 'link_docs'=>'assets/files/products/carbide_end_mill.pdf'),
			array('name'=>'Milling Cutter', 'picture'=>'assets/images/products/milling_cutter.png', 'link_docs'=>'assets/files/products/milling_cutter.pdf'),
			array('name'=>'Screw on end Mills', 'picture'=>'assets/images/products/screw_on_end_mills.png', 'link_docs'=>'assets/files/products/screw_on_end_mills.pdf'),
			array('name'=>'Turning Tool Holders', 'picture'=>'assets/images/products/turning_tool_holders.png', 'link_docs'=>'assets/files/products/turning_tool_holders.pdf'),
			array('name'=>'Threading Inserts', 'picture'=>'assets/images/products/threading_inserts.png', 'link_docs'=>'assets/files/products/threading_inserts.pdf'),
			array('name'=>'Turning Tools', 'picture'=>'assets/images/products/turning_tools.jpg', 'link_docs'=>'assets/files/products/turning_tools.pdf'),
			array('name'=>'SCRoads A5', 'picture'=>'assets/images/products/scrods_a5.jpg', 'link_docs'=>'assets/files/products/scrods_a5.pdf'),
			array('name'=>'ACME and TR', 'picture'=>'assets/images/products/acme_and_tr.png', 'link_docs'=>'assets/files/products/acme_and_tr.pdf'),
			array('name'=>'NICHE Modular Milling', 'picture'=>'assets/images/products/niche_modular_milling.png', 'link_docs'=>'assets/files/products/niche_modular_milling.pdf'),
			array('name'=>'NICHE Solid Carbide Drills', 'picture'=>'assets/images/products/niche_solid_carbide_drills.png', 'link_docs'=>'assets/files/products/niche_solid_carbide_drills.pdf'),
			array('name'=>'TCEA ReplaceableTip Drill', 'picture'=>'assets/images/products/tcea_replaceabletip_drill.png', 'link_docs'=>'assets/files/products/tcea_replaceabletip_drill.pdf'),
			array('name'=>'Boring Tools', 'picture'=>'assets/images/products/boring_tools.png', 'link_docs'=>'assets/files/products/boring_tools.pdf'),
			array('name'=>'Shrink-Fit Holder 2023', 'picture'=>'assets/images/products/shrink_fit_holder_2023.png', 'link_docs'=>'assets/files/products/shrink_fit_holder_2023.pdf'),
			array('name'=>'NICHE Taps 2023', 'picture'=>'assets/images/products/niche_taps_2023.png', 'link_docs'=>'assets/files/products/niche_taps_2023.pdf')
		);

		$masters = 'layouts/master_'.$language;
		$layouts = $this->path.'/products/index_'.$language;
		$request = array(
			'layouts'=>$layouts,
			'page_active'=>$page_active,
			'language'=>$language,
			'data'=>array(
				'page_title'=>$page_title,
				'products'=>$products
			)
		);

		return view($masters, $request);
	}
}