<?php namespace App\Controllers;

class Sites extends BaseController {

	private $path = 'templates';

	public function index() {
		$language = $this->session->language;
		$page_title = 'Home';
		$page_active = 'home';

		$banners = array();
		foreach (range(3, 12) as $key=>$val) {
			array_push($banners, array(
				'name'=>'Banner '.$val,
				'picture'=>'assets/images/banners/banner'.$val.'.jpeg'
			));
		}

		$masters = 'layouts/master_'.$language;
		$layouts = $this->path.'/sites/index_'.$language;
		$request = array(
			'layouts'=>$layouts,
			'page_active'=>$page_active,
			'language'=>$language,
			'data'=>array(
				'page_title'=>$page_title,
				'banners'=>$banners
			)
		);

		return view($masters, $request);
	}

	public function change_language($lang = 'en') {
		$lang = strtolower($lang);

		if (!in_array($lang, array('en', 'id'))) {
			$lang = $this->session->language;
		}
		$this->session->set('language', $lang);

		return redirect()->back();
	}
}